/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

/* This MX kernel lib code was originally contributed by
 * Brice.Goglin@ens-lyon.org (LIP/INRIA/ENS-Lyon) */

#ifndef _mx_klib_h_
#define _mx_klib_h_

#include "mx_arch.h"
#include "mx_malloc.h"
#include "mx_instance.h"
#include "mx_arch_klib.h"

/* forward declarations */
struct mx_endpt_state;
extern mx_klib_mutex_t mx_klib_lock;
#define MX_LOCK &mx_klib_lock

/* entry points */
int mx_init_klib(void);
void mx_finalize_klib(void);

int
mx_klib_open(mx_endpt_state_t **es);
int
mx_klib_map(mx_endpt_state_t *es,
	    char **sendq, char **eventq, char **recvq, char **sram, char **zreq);
int
mx_klib_ioctl(mx_endpt_state_t *es, int cmd, void *p, size_t size);
int
mx_klib_close(mx_endpt_state_t *es);

int
mx_klib_set_endpoint(mx_endpt_state_t **es, uint32_t unit,
		     uint32_t endpoint, uint32_t *session_id);

/* fops replacement */
#define mx__open(unit, endpoint, handlep) mx_klib_open(handlep)
#define mx__ioctl(handle, cmd, arg, size) mx_klib_ioctl(handle, cmd, arg, size)
#define mx__close(handle) mx_klib_close(handle)
#define mx__map(ep) mx_klib_map(ep->handle, &ep->sendq, &ep->eventq, &ep->recvq, &ep->sram, &ep->ze_req)
#define mx__unmap(handle) do { /* nothing */ } while (0)

/* std header replacement */
#define mx_malloc(size) mx_kmalloc(size, MX_WAITOK)
#define mx_free(ptr) mx_kfree(ptr)
#define mx_calloc(n, size) mx_kmalloc(n*size, MX_MZERO)
#define mx_memcpy(x,y,z) bcopy(y,x,z)
#define mx_strlen(s) mx_klib_strlen(s)
#define mx_printf(args...) mx_klib_printf(args)
#define mx_snprintf(args...) mx_klib_snprintf(args)
#define mx_sprintf(args...) mx_klib_sprintf(args)
#define mx_strerrno "??"
#define mx_errno -1
#define mx_getpid() mx_klib_getpid()
#define mx_strtol mx_klib_strtol
#define mx_gettimeofday(x,y) mx_klib_gettimeofday(x,y)

/* copy from/to segments */
static inline int
mx_memcpy_to_segment(uint64_t segment_ptr, void *ptr,
		     size_t amount, uintptr_t memory_context)
{
  int status = 0;

  status = mx_arch_memcpy_to_segment(segment_ptr, ptr, amount, memory_context);
  if (status == EINVAL) {
    switch (memory_context) {
    case MX_PIN_KERNEL:
      bcopy(ptr, MX_U64_TO_KVA(segment_ptr), amount);
      break;
    default:
      status = mx_arch_copyout(ptr, /* XXX MacOSX 10.4 */
			       MX_U64_TO_UVA(segment_ptr),
			       amount);
      break;
    }
  }
  return status;
}

static inline int
mx_memcpy_from_segment(void *ptr, uint64_t segment_ptr,
		       size_t amount, uintptr_t memory_context)
{
  int status = 0;

  status = mx_arch_memcpy_from_segment(ptr, segment_ptr, amount, memory_context);
  if (status == EINVAL) {
    switch (memory_context) {
    case MX_PIN_KERNEL:
      bcopy(MX_U64_TO_KVA(segment_ptr), ptr, amount);
      break;
    default:
      status = mx_arch_copyin(MX_U64_TO_UVA(segment_ptr),
			      ptr, amount);
      break;
    }
  }
  return status;
}

#endif /* _mx_klib_h_ */
